# Simulation B – Pure Dephasing (Present‑Act V2.1)

This repository implements **Simulation B** in the Present‑Act V2.1 series.  It
extends the boolean/ordinal engine used in Simulation A by adding a
time/phase jitter instrument.  Each history acquires a random relative
phase offset \(\Delta\varphi\) drawn from a specified distribution and is
classified on a screen by discretised phase windows.  The main goal is to
measure the fringe visibility \(V\) as a function of the jitter
parameter and to show that the attenuation matches the characteristic
function of the jitter law.

Two jitter families are provided:

* **Gaussian:** \(\Delta\varphi \sim \mathcal{N}(0, \sigma^2)\).  The predicted
  visibility is \(V(\sigma) = e^{-\sigma^2/2}\).
* **Uniform:** \(\Delta\varphi \sim U[-a,a]\).  The predicted visibility
  is \(V(a) = |\sin a|/a\) with the convention \(V(0)=1\).

In both cases, the measured visibility comes from counting screen hits
falling into phase windows centred at 0 (constructive) and \(\pi\)
(destructive).  The implementation retains all invariants from
Simulation A: strictly boolean/ordinal acceptance with no weights,
nearest‑neighbour composition, and PF/Born sampling only at exact ties.

## Layout

```
pa_v2_simB/
├── README.md                # this file
├── env/
│   └── environment.yml      # conda environment specification
├── seeds.yaml               # global seeds [101, 202, 303]
├── engine/                  # boolean/ordinal engine (copied from Sim‑A)
│   ├── accept.py
│   ├── gates.py
│   ├── tie_kernel.py
│   ├── rng.py
│   ├── lattice.py
│   └── meter.py
├── instruments/
│   ├── jitter.py            # jitter sampling and phase utilities
│   └── screen_phase.yaml    # phase window definitions (B, centres, eps_bins)
├── sim/
│   ├── manifest.yaml        # experiment configuration
│   └── run.py               # driver script
├── analysis/
│   ├── metrics.py           # compute V, predictions and errors
│   └── plots.py             # generate figures
└── results/
    ├── raw/                 # CSVs written here
    └── figs/                # figures written here
```

## Quick start

```bash
# create environment
conda env create -f env/environment.yml
conda activate pa_v2_simB

# run the simulation (baseline + ablations)
python sim/run.py --manifest sim/manifest.yaml

# make plots
python analysis/plots.py --summary results/raw/simB_summary.csv --output_dir results/figs
```

The simulation writes per‑seed results to `results/raw/simB_summary.csv`,
ablation results to `results/raw/simB_ablation.csv`, and median tables to
`results/raw/simB_summary_median.csv`.  Figures are saved in
`results/figs/`.

## Notes

- **Phase mapping.**  Screen columns are mapped to geometric phases
  \(\phi_{\text{geom}}(x) = 2\pi\,(x - x_0)/P\).  The chosen period and
  centre (`P=16`, `x0=Lx//2`) are verified once with a pilot at zero
  jitter and then held fixed.
- **Jitter quantisation.**  Phase offsets are drawn from the selected
  law, wrapped to \((-\pi, \pi]\), quantised into `B=64` bins, and
  added to the geometric phase bin before classification.
- **Predictions.**  The analytic predictions for the visibility are
  included in the output and plotted alongside the measured values.
- **Ablations.**  Three falsification modes are provided: (1) using a
  continuous tiebreak instead of PF/Born at ties, (2) allowing skip
  moves/diagonals, and (3) drifting the phase quantisation mid‑run.
